/*
 *
 *	i2cl16.h    ( Light Optimized Version )
 *	v1.0 (22/04/2003)
 *
 *	16 bits address memory acces for i2c protocol
 *	Library for HI-TECH PIC C - master mode only.
 *  Light version without returned error code, optimized to reduce code size
 *	Supported divices: 24xx32, 24xx64, 24xx65, 24xx128, 24xx256
 *
 *	This library use light version of i2c library for low level I/O.
 *
 *	Written by Philippe Corbes <philippe.corbes@laposte.net>
 *	This code is free for personal use.
 *	You need my agreement for a commercial use. 
 *
 */

//-------------------- I2C global defs --------------------

#define	I2C_EEPROM_UPDATE	11		/* Delay for transfert cache to EEPROM */

// Struct used to acces to i2c bus 
typedef struct I2C16 {
	unsigned char	component;		/* Control byte in he i2c protocol*/
	unsigned int	address;		/* Addres to acces in the component */
	unsigned char	data;			/* Return value.  */
};

extern struct I2C16  i2c16 ;		/* Global struct defined in i2cL16.c */

//------------------- TODO in your code: --------------------
//
// 1) Before anything, call i2c_init()
// 2) You need before read or write component, init witch component you want acces 
//    and at witch address. Take care to init :
//    i2c16.component  and  i2c16.address
// 3) Call read or write function
// 4) Read i2c16.data if you read component
//

//------------------- Functions interface --------------------

/*
 * 	Read a byte from the slave and acknowledges the transfer
 *
 *  Input:  - i2c16.component
 *          - i2c16.address
 * 	Output:	update i2c16.data
 */
extern void
i2c16_read(void);


/*
 *  Write specified data byte in i2c device 
 *
 *  Input:  - i2c16.component
 *          - i2c16.address
 * 	Output:	nothing
 */
extern void
i2c16_write(unsigned char	data );


/*
 * 	Read a numbrer of bytes and strore them at '*data'
 *  The number of bytes to read is specified by 'length'
 *
 *  Input:  - i2c16.component
 *          - i2c16.address
 * 	Output:	nothing
 */
extern void
i2c16_read_seq(	unsigned char	length, 
				unsigned char	*abyte);


/*
 *  Write a numbrer of bytes from '*data' to the i2c component
 *  The number of bytes to write is specified by 'length'
 *
 *  Input:  - i2c16.component
 *          - i2c16.address
 * 	Output:	nothing
 */
extern void
i2c16_write_seq(unsigned char	length, 
				unsigned char	*abyte);
