/*
 *
 *	i2cl.h    ( Light Version )
 *	v1.0 (17/04/2003)
 *
 *	Software implementation of the I2C protocol
 *	Definitions for Light Low level I2C - master mode only.
 *
 *	Input and output may be on the same resister. 
 *	Define SCL (clock) and SDA (data) pin i this file.
 *	Run i2c_init() one time before read/write.
 *
 *	Written by Philippe Corbes <philippe.corbes@laposte.net>
 *	This code is free for personal use. 
 *	You need my agreement for a commercial use. 
 *
 */

 
#ifndef	_I2C_H_
#define _I2C_H_


//----------------- I2C interface parameters ----------------- 

// Edit this parameters

#define SCL				RC3             /* clock on port C bit 3 */
#define SCL_DIR			TRISC3
#define SDA				RC4             /* data on port C bit 4 */
#define SDA_DIR			TRISC4
#define I2C_IOMASK		0b00011000		/* TAKE CARE to locate SCL and SDA */
										/* TAKE CARE to chose good register */
#define i2c_init()		PORTC&=(~I2C_IOMASK); TRISC|=I2C_IOMASK;
#define i2c_repStart()	i2c_start()

//
// Timings for the i2c bus. Times are rounded up to the nearest
// micro second. You may adjust this timing
//
#define I2C_THD_STA		5
#define I2C_TSU_STA		5
#define I2C_TSU_DAT		4
#define I2C_TTR			3

#define	I2C_THIGH		5
#define I2C_TLOW		4

#define	I2C_TSU_STO		4
#define	I2C_TBUF		5

//------------------- Macro used in i2c.c --------------------

#define SCL_HIGH()	SCL_DIR = 1
#define SCL_LOW()	SCL_DIR = 0
#define SDA_HIGH()	SDA_DIR = 1
#define SDA_LOW()	SDA_DIR = 0


//----------------- Constants for parameters -----------------

#define I2C_LAST		0		/* SendAck: no more bytes to send */
#define I2C_MORE		1		/* SendAck: more bytes to send */

//------------------- Functions interface --------------------

extern void				i2c_start(void);
extern void				i2c_stop(void);

extern void				i2c_write(unsigned char);
extern unsigned char	i2c_read(unsigned char);

#endif			/* _I2C_H_ */
