/*
 * testi2c.c
 * PC le 17/04/2003
 *
 * Ce programme utilise la version 'academique Light' de la libraire i2c16
 *
 * Teste la lecture d'une memoire 24C65 (I2C).
 * Une resistance de rappel doit etre connectee a Vcc pour chaques sorties.
 * SCL (clock) en 3 et SDA (data) en4 du port C.
 *
 */

#include <pic.h>
#include <stdio.h>
#include "delay.h"
#include "sci.h"
#include "i2c.h"
#include "i2cl16.h"




__CONFIG( XT & UNPROTECT & BORDIS & WDTDIS & PWRTDIS );



// works only for 0,...F values.
unsigned char convHex(unsigned char abyte) {
  if (abyte < 0x0a) {
    return abyte + 0x30;
  } else {
    return abyte + 0x37;
  }
}

void putHex(unsigned char ch) {
  putch(convHex(ch>>4));
  putch(convHex(ch&0xf));
}

#define	TAILLE_MEMOIRE 9192;


void main(void) {
	int ad;
	int i;
	char test[9] ;
	
	TRISB=0; 		/* debug */
	PORTB=255;
	
	i2c_init();
	
	init_uart();

// Premiere lecture
	cputs("\n\rLecture unitaire\n\r");
	for(ad=0;(ad<8192);ad++) {
		if ((ad&0xF) == 0) {
			putch('\n');
			putch('\r');
			putHex(ad>>8); 
			putHex((unsigned char)ad); 
			putch(' ');
		}

		putHex(i2c16_read(0xa8, ad));
		putch(' ');
	}


// Deuxieme lecture
	cputs("\n\r\n\rLecture par bloc\n\r");
	for ( ad=0;ad<8192;ad+=8) {
		if ((ad&0xF) == 0) {
			putch('\n');
			putch('\r');
			putHex(ad>>8); 
			putHex((unsigned char)ad);
			putch(' ');
		}

		i2c16_read_seq(0xa8, ad, 8, test);

		for(i=0;i<8;i++) {
			putHex(test[i]);
			putch(' ');
		}
	}

	while(1) {};
}


