/*
 *
 *	i2cl16.h    ( Light Version )
 *	v1.0 (17/04/2003)
 *
 *	16 bits address memory acces for i2c protocol
 *	Library for HI-TECH PIC C - master mode only.
 *  Light version without returned error check
 *	Supported divices: 24xx32, 24xx64, 24xx65, 24xx128, 24xx256
 *
 *	This library use light version of i2c library for low level I/O.
 *
 *	Written by Philippe Corbes <philippe.corbes@laposte.net>
 *	This code is free for personal use.
 *	You need my agreement for a commercial use. 
 *
 */

#define	I2C_EEPROM_UPDATE	11		/* Delay for transfert cache to EEPROM */

extern unsigned char
i2c16_read(	unsigned char	component,
			unsigned int	address);

extern void
i2c16_write(	unsigned char	component,
				unsigned int	address, 
				unsigned char	abyte );


extern void
i2c16_read_seq(	unsigned char	component,
				unsigned int	address,
				unsigned char	length,
				unsigned char	*abyte);

extern void
i2c16_write_seq(unsigned char	component,
				unsigned int	address,
				unsigned char	length,
				unsigned char	*abyte);
